import javax.media.j3d.*;
import javax.vecmath.*; 
import java.awt.*;
import java.awt.event.*;
import com.sun.j3d.utils.behaviors.mouse.*;
import com.sun.j3d.utils.geometry.*;
/**
 * This application demonstrates the use of the mouse
 * utility classes.  It allows rotation, translation and
 * resizing of the screen image of 
 * a cube by clicking and dragging the mouse on the shape.
 * @author I.J.Palmer
 * @version 1.0
 */
public class SimpleMouse extends Frame implements ActionListener {
    protected Canvas3D myCanvas3D = new Canvas3D(null);
    protected Button exitButton = new Button("Exit");
    protected BoundingSphere bounds = new BoundingSphere(new Point3d(0.0,0.0,0.0), 100.0);
    /** 
     * Build the view branch of the scene graph 
     * @return BranchGroup that is the root of the view branch
     */
     protected BranchGroup buildViewBranch(Canvas3D c) {
		BranchGroup viewBranch = new BranchGroup();
		Transform3D viewXfm = new Transform3D();
            	viewXfm.set(new Vector3f(0.0f,0.0f,10.0f));
		TransformGroup viewXfmGroup = new TransformGroup(viewXfm);
		ViewPlatform myViewPlatform = new ViewPlatform();
            	PhysicalBody myBody = new PhysicalBody();
            	PhysicalEnvironment myEnvironment = new PhysicalEnvironment();
		viewXfmGroup.addChild(myViewPlatform);
		viewBranch.addChild(viewXfmGroup);
		View myView = new View();
		myView.addCanvas3D(c);
		myView.attachViewPlatform(myViewPlatform);
            	myView.setPhysicalBody(myBody);
            	myView.setPhysicalEnvironment(myEnvironment);
		return viewBranch;
	}
      /** 
       * Add some lights to the scene graph 
       * @param b BranchGroup that the lights are added to
       */
      protected void addLights(BranchGroup b) {
		Color3f ambLightColour = new Color3f(0.5f, 0.5f, 0.5f);
		AmbientLight ambLight = new AmbientLight(ambLightColour);
            	ambLight.setInfluencingBounds(bounds);
            	Color3f dirLightColour = new Color3f(1.0f, 1.0f, 1.0f);
            	Vector3f dirLightDir  = new Vector3f(-1.0f, -1.0f, -1.0f);
            	DirectionalLight dirLight = new DirectionalLight(dirLightColour, dirLightDir);
            	dirLight.setInfluencingBounds(bounds);
		b.addChild(ambLight);
            	b.addChild(dirLight);
      }
      /** 
       * Build the content branch for the scene graph
       * @return BranchGroup that is the root of the content
       */
      protected BranchGroup buildContentBranch() {
		Appearance app = new Appearance();
            	Color3f ambientColour = new Color3f(1.0f,0.0f,0.0f);
            	Color3f emissiveColour = new Color3f(0.0f,0.0f,0.0f);
		Color3f specularColour = new Color3f(1.0f,1.0f,1.0f);
            	Color3f diffuseColour = new Color3f(1.0f,0.0f,0.0f);
            	float shininess = 20.0f;
            	app.setMaterial(new Material(ambientColour,emissiveColour,
            			diffuseColour,specularColour,shininess));

		Box cube = new Box(2.0f,2.0f,2.0f, app);

		BranchGroup contentBranch = new BranchGroup();
            	addLights(contentBranch);
            //Create the transform groups that will be 
            //affected by the mouse utiltities
		TransformGroup spinGroup = new TransformGroup();
		TransformGroup zoomGroup = new TransformGroup();
		TransformGroup moveGroup = new TransformGroup();
            //Set the capabilities of the groups so that we can 
            //manipulate them
		spinGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
                spinGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		zoomGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
                zoomGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		moveGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
                moveGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
            //Create and use the rotation utility
                MouseRotate mouseSpin = new MouseRotate();
                mouseSpin.setTransformGroup(spinGroup);
                contentBranch.addChild(mouseSpin);
                mouseSpin.setSchedulingBounds(bounds);
            //Create and use the zoom utility
                MouseZoom mouseSize = new MouseZoom();
                mouseSize.setTransformGroup(zoomGroup);
                contentBranch.addChild(mouseSize);
                mouseSize.setSchedulingBounds(bounds);
            //Create and use the translation utility
                MouseTranslate mouseMove = new MouseTranslate();
                mouseMove.setTransformGroup(moveGroup);
                contentBranch.addChild(mouseMove);
                mouseMove.setSchedulingBounds(bounds);
            //Put it all together
		spinGroup.addChild(cube);
		moveGroup.addChild(spinGroup);
		zoomGroup.addChild(moveGroup);
		contentBranch.addChild(zoomGroup);
		return contentBranch;

      	} 
      /** Use the action event of the exit button
       * to end the application.
       */
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == exitButton) {
			dispose();
                	System.exit(0);
		}
	}
        public SimpleMouse() {
		VirtualUniverse myUniverse = new VirtualUniverse();
		Locale myLocale = new Locale(myUniverse);
                myLocale.addBranchGraph(buildViewBranch(myCanvas3D));
                myLocale.addBranchGraph(buildContentBranch());
		setTitle("SimpleMouse");
		setSize(400,400);
		setLayout(new BorderLayout());
		Panel bottom = new Panel();
		bottom.add(exitButton);
                add(BorderLayout.CENTER, myCanvas3D);
                add(BorderLayout.SOUTH, bottom);
                exitButton.addActionListener(this);
                setVisible(true);
	}
	public static void main(String[] args) {
                  SimpleMouse sm = new SimpleMouse();
	}
}

